<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Player extends Model 
{

    protected $table = 'players';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function teams()
    {
        return $this->belongsToMany('App\Classes\Team');
    }

    public function skills()
    {
        return $this->hasMany('App\Classes\Skill');
    }

    public function type()
    {
        return $this->hasOne('App\Classes\PlayerType');
    }

    public function race()
    {
        return $this->hasOne('App\Classes\Race');
    }

    public function upgrades()
    {
        return $this->hasMany('App\Classes\Upgrade');
    }

}